function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const assert = require('assert');

const buildCtx = opts => {
  const ctx = _objectSpread({
    joined: true,
    spacerNoNeighbour: '   ',
    spacerNeighbour: '│  ',
    keyNoNeighbour: '└─ ',
    keyNeighbour: '├─ ',
    sortFn: null
  }, opts);

  assert(typeof ctx.joined === 'boolean');
  assert(typeof ctx.spacerNoNeighbour === 'string');
  assert(typeof ctx.spacerNeighbour === 'string');
  assert(typeof ctx.keyNoNeighbour === 'string');
  assert(typeof ctx.keyNeighbour === 'string');
  assert(typeof ctx.sortFn === 'function' || ctx.sortFn === null);
  return ctx;
};

module.exports = (tree, opts = {}) => {
  const ctx = buildCtx(opts);
  const result = [];

  const sort = input => ctx.sortFn === null ? input.reverse() : input.sort((a, b) => ctx.sortFn(b, a));

  const neighbours = [];
  const keys = sort(Object.keys(tree)).map(k => [k]);
  const lookup = [tree];

  while (keys.length !== 0) {
    const key = keys.pop();
    const node = lookup[key.length - 1][key[key.length - 1]];
    neighbours[key.length - 1] = keys.length !== 0 && keys[keys.length - 1].length === key.length;
    result.push([neighbours.slice(0, key.length - 1).map(n => n ? ctx.spacerNeighbour : ctx.spacerNoNeighbour).join(''), neighbours[key.length - 1] ? ctx.keyNeighbour : ctx.keyNoNeighbour, key[key.length - 1], ['boolean', 'string', 'number'].includes(typeof node) ? `: ${node}` : ''].join(''));

    if (node instanceof Object && !Array.isArray(node)) {
      keys.push(...sort(Object.keys(node)).map(k => key.concat(k)));
      lookup[key.length] = node;
    }
  }

  return ctx.joined === true ? result.join('\n') : result;
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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