"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _util = _interopRequireDefault(require("util.promisify"));

var _child_process = _interopRequireDefault(require("child_process"));

var _util2 = require("./util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const exec = (0, _util.default)(_child_process.default.exec);
/**
 * Checks out a commit given its repo and hash.
 *
 * Returns void. Throws error on failure.
 */

const checkoutCommit = async (pathToRepo, hash, options = {
  force: false
}) => {
  const resolvedPath = (0, _util2.resolveHome)(pathToRepo);

  try {
    (0, _util2.validatePath)(resolvedPath);
  } catch (e) {
    return Promise.reject(e);
  }

  return exec(`git checkout ${hash} ${options.force ? '--force' : ''}`, {
    cwd: resolvedPath
  });
};

var _default = checkoutCommit;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9jaGVja291dF9jb21taXQuanMiXSwibmFtZXMiOlsiZXhlYyIsImNoaWxkUHJvY2VzcyIsImNoZWNrb3V0Q29tbWl0IiwicGF0aFRvUmVwbyIsImhhc2giLCJvcHRpb25zIiwiZm9yY2UiLCJyZXNvbHZlZFBhdGgiLCJlIiwiUHJvbWlzZSIsInJlamVjdCIsImN3ZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOzs7O0FBRUEsTUFBTUEsSUFBSSxHQUFHLG1CQUFVQyx1QkFBYUQsSUFBdkIsQ0FBYjtBQUVBOzs7Ozs7QUFLQSxNQUFNRSxjQUFjLEdBQUcsT0FBT0MsVUFBUCxFQUFtQkMsSUFBbkIsRUFBeUJDLE9BQU8sR0FBRztBQUFDQyxFQUFBQSxLQUFLLEVBQUU7QUFBUixDQUFuQyxLQUFzRDtBQUMzRSxRQUFNQyxZQUFZLEdBQUcsd0JBQVlKLFVBQVosQ0FBckI7O0FBRUEsTUFBSTtBQUNGLDZCQUFhSSxZQUFiO0FBQ0QsR0FGRCxDQUVFLE9BQU9DLENBQVAsRUFBVTtBQUNWLFdBQU9DLE9BQU8sQ0FBQ0MsTUFBUixDQUFlRixDQUFmLENBQVA7QUFDRDs7QUFFRCxTQUFPUixJQUFJLENBQUUsZ0JBQWVJLElBQUssSUFBR0MsT0FBTyxDQUFDQyxLQUFSLEdBQWdCLFNBQWhCLEdBQTRCLEVBQUcsRUFBeEQsRUFBMkQ7QUFDcEVLLElBQUFBLEdBQUcsRUFBRUo7QUFEK0QsR0FBM0QsQ0FBWDtBQUdELENBWkQ7O2VBY2VMLGMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgcHJvbWlzaWZ5IGZyb20gJ3V0aWwucHJvbWlzaWZ5JztcbmltcG9ydCBjaGlsZFByb2Nlc3MgZnJvbSAnY2hpbGRfcHJvY2Vzcyc7XG5pbXBvcnQge3ZhbGlkYXRlUGF0aCwgcmVzb2x2ZUhvbWV9IGZyb20gJy4vdXRpbCc7XG5cbmNvbnN0IGV4ZWMgPSBwcm9taXNpZnkoY2hpbGRQcm9jZXNzLmV4ZWMpO1xuXG4vKipcbiAqIENoZWNrcyBvdXQgYSBjb21taXQgZ2l2ZW4gaXRzIHJlcG8gYW5kIGhhc2guXG4gKlxuICogUmV0dXJucyB2b2lkLiBUaHJvd3MgZXJyb3Igb24gZmFpbHVyZS5cbiAqL1xuY29uc3QgY2hlY2tvdXRDb21taXQgPSBhc3luYyAocGF0aFRvUmVwbywgaGFzaCwgb3B0aW9ucyA9IHtmb3JjZTogZmFsc2V9KSA9PiB7XG4gIGNvbnN0IHJlc29sdmVkUGF0aCA9IHJlc29sdmVIb21lKHBhdGhUb1JlcG8pO1xuXG4gIHRyeSB7XG4gICAgdmFsaWRhdGVQYXRoKHJlc29sdmVkUGF0aCk7XG4gIH0gY2F0Y2ggKGUpIHtcbiAgICByZXR1cm4gUHJvbWlzZS5yZWplY3QoZSk7XG4gIH1cblxuICByZXR1cm4gZXhlYyhgZ2l0IGNoZWNrb3V0ICR7aGFzaH0gJHtvcHRpb25zLmZvcmNlID8gJy0tZm9yY2UnIDogJyd9YCwge1xuICAgIGN3ZDogcmVzb2x2ZWRQYXRoXG4gIH0pO1xufTtcblxuZXhwb3J0IGRlZmF1bHQgY2hlY2tvdXRDb21taXQ7XG4iXX0=