var PANEL_EAST_OPEN = false,
    centerPanel,
    setFlag,
    flagRefresh = true,
    debugVarTpl = new Ext.Template('<span style="font-size:11">{value}</span>'),
    detailsText = '<i></i>',
    debugTriggersDetailTpl = new Ext.Template('<pre style="font-size:10px"><code>{code}</code></pre>'),
    propStore,
    triggerStore,
    result,
    _action = '',
//@var treeMenuItemsLoaded -> added to flag the "treeMenuItems" tree, to ensure that its onload event is executed just once
    treeMenuItemsLoaded = false,
    loader,
    _BROWSER;

debugVarTpl.compile();
debugTriggersDetailTpl.compile();

setFlag = function (val) {
    flagRefresh = val;
};

Ext.BLANK_IMAGE_URL = "data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==";
Ext.onReady(function(){
  new Ext.KeyMap(document, {
    key: Ext.EventObject.F5,
    fn: function(keycode, e) {
      if (! e.ctrlKey) {
        if (Ext.isIE) {
          e.browserEvent.keyCode = 8;
        }
        e.stopEvent();
        updateCasesTree();
        highlightCasesTree();
      }
      else
       	Ext.Msg.alert(_('ID_REFRESH_LABEL'),_('ID_REFRESH_MESSAGE'));
    }
  });

  Ext.QuickTips.init();
  Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

  var resetGrid = function() {
    propStore.load();
  };
  var resetTriggers = function(){
    triggerStore.load();
  };

  var debugVariablesFilterDynaform = function(){
    propStore.load({params:{filter:'dyn'}});
  };

  var debugVariablesFilterSystem = function(){
    propStore.load({params:{filter:'sys'}});
  };

  //center iframe panel
  centerPanel = {
    region : 'center',
    xtype  : 'iframepanel',
    frameConfig:{
      name : 'casesSubFrame',
      id   : 'casesSubFrame'
    },
    deferredRender: false
  };

  /**
   * Menu Panel
   */
  var treeMenuItems = new Ext.tree.TreePanel({
    xtype: 'treepanel',
    height: 350,
    id: 'tree-panel',
    region: 'center',
    margins: '0 0 0 0',
    useArrows : true,

    animate:true,
    autoScroll: true,
    rootVisible: false,
    clearOnReLoad: false,
    root: new Ext.tree.AsyncTreeNode(),
    useArrows: true,

    // Our custom TreeLoader:
    loader: new Ext.app.menuLoader({
      dataUrl:'casesMenuLoader',
      clearOnLoad: false
    }),

    listeners: {
      'click': function(tp) {
        if( tp.attributes.url ){
          document.getElementById('casesSubFrame').src = tp.attributes.url;
        }
      },
      'render': function(tp){}
    }
  });
    /**
     * Gets the user client browser and its version
     * @return (object)
     */
    function getBrowserClient() {
        var browsers = ["opera", "msie", "firefox", "opera", "safari", "trident"],
            infoBrowser = navigator.userAgent.toLowerCase(),
            versionBrowser,
            currentBrowser = "";
        for (var i = 0; i < browsers.length; i++) {
            if ((currentBrowser === "") && (infoBrowser.indexOf(browsers[i]) !== -1)) {
                currentBrowser = browsers[i];
                versionBrowser = String(parseFloat(infoBrowser.substr(infoBrowser.indexOf(browsers[i]) + browsers[i].length + 1)));
                return {name: currentBrowser, browser: currentBrowser, version: versionBrowser}
            }
        }
        return false;
    }
    _BROWSER = getBrowserClient();
    loader = treeMenuItems.getLoader();
    loader.on("load", function () {
        var treePanel1,
            node;
        // it was added since the feature to reload a specific node of tree is now working
        if (!treeMenuItemsLoaded) { // this section of code should be executed once
            if ((_BROWSER.name === "msie" || _BROWSER.name === "trident") && openCaseIE) {
                parent.window.location.href = defaultOption;
            } else {
                document.getElementById('casesSubFrame').src = defaultOption;
                // check if a case was open directly
                if (defaultOption.indexOf('open') > -1) {
                    //if it is, then update cases trees
                    updateCasesTree();
                    highlightCasesTree();
                }
                if (_nodeId !== '') {
                    treePanel1 = Ext.getCmp('tree-panel');
                    if (treePanel1) {
                        node = treePanel1.getNodeById(_nodeId);
                    }
                    if (node) {
                        node.select();
                        if (_nodeId === 'CASES_START_CASE') {
                            updateCasesTree();
                            highlightCasesTree();
                        }
                    }
                }
            }
            treeMenuItemsLoaded = true;
        }
    });

  // set the root node
  var root = new Ext.tree.AsyncTreeNode({
      text: 'Ext JS',
      draggable:false, // disable root node dragging
      id:'src',
      loaded:false,
      expanded:true
  });

  mainMenu = new Ext.Panel({
    id:'menuTreePanel',
    title: '',
    region: regionTreePanel,
    layout: 'border',
    width: 200,
    height: 500,
    minSize: 175,
    maxSize: 400,
    split: true,
    collapsible: true,
    collapseMode: 'mini',
    margins: '0 0 0 2',

    items: [
      treeMenuItems
    ]
  });
  mainMenu.setTitle("<div style=\"height: 18px;\"><a href=\"javascript:;\"><img id=\"refreshNotifiers\" " +
    "src=\"/images/refresh.gif\" onclick=\"updateCasesTree(); highlightCasesTree(); updateCasesView();\" /></a></div>");

  propStore = new Ext.data.Store({
      proxy: new Ext.data.HttpProxy({url: 'debug_vars'}),
      reader: new Ext.data.DynamicJsonReader({root: 'data'})
  });

  propStore.on('load', function(){
      propStore.fields = propStore.recordType.prototype.fields;
      debugVariables.setSource(propStore.getAt(0).data);
  });

  /**
   * Triggers Panel
   */
  var debugVariables = new Ext.grid.PropertyGrid({
      id: 'debugVariables',
      title:TRANSLATIONS.ID_VARIABLES,
      autoHeight: false,
      height: 300,
      width: 400,
      region: 'center',
      margins: '2 2 0 2',
      border: true,
      stripeRows: true,
      listeners: {
          beforeedit: function(event) { //Cancel editing - read only
              event.cancel = true;
          }
      },
      tbar: [
          {text: TRANSLATIONS.ID_ALL, handler: resetGrid},
          {text: TRANSLATIONS.ID_DYNAFORM, handler: debugVariablesFilterDynaform},
          {text: TRANSLATIONS.ID_SYSTEM, handler: debugVariablesFilterSystem}
      ],
      sm: new Ext.grid.RowSelectionModel({singleSelect: true}),
      viewConfig: {
          forceFit: true
      }
  });

  //set debug variable details
  debugVariables.getSelectionModel().on('rowselect', function(sm, rowIdx, r) {
      var detailPanel = Ext.getCmp('debug-details-panel'),
          d = {};
      d.name  = r.data.name;
      d.value = parent.parent.htmlentities ? parent.parent.htmlentities(r.data.value) : r.data.value;
      debugVarTpl.overwrite(detailPanel.body, d);
      detailPanel.setTitle(r.data.name);

      if(r.data.value === '<object>' || r.data.value === '<array>' ){
          Ext.getCmp('deatachAction').setDisabled(false);
          Ext.Ajax.request({
              url: 'debug_vars?r='+Math.random(),
              success: function(response){
                  try{
                      result = eval('('+response.responseText+')');

                      var store1a = new Ext.data.ArrayStore({fields: result.headers});
                      // manually load local data
                      store1a.loadData(result.rows);

                      var myGridPanel = new Ext.grid.GridPanel({
                          store: store1a,
                          height: 200,
                          border : false,
                          columns: result.columns,
                          stripeRows : true,
                          layout: 'fit',
                          viewConfig:{forceFit:true, scrollOffset:0},
                          listeners: {
                              rowdblclick: function(grid, n,e){

                              },
                              render: function(){
                                  this.loadMask = new Ext.LoadMask(this.body, { msg:_('ID_LOADING_GRID') });
                              }
                          }
                      });

                      Ext.each(detailPanel.items.items, function(childPanel) {
                          detailPanel.remove(childPanel, true);
                      });

                      detailPanel.add(myGridPanel);
                      detailPanel.doLayout();
                  } catch (e){

                  }
              },
              failure: function(){},
              params: {request: 'getRows', fieldname:r.data.name}
          });
      } else
          Ext.getCmp('deatachAction').setDisabled(true);

  });

  /**
   * Triggers Panel
   */
  var xg = Ext.grid;

  var reader = new Ext.data.JsonReader(
    {
      root: 'data',
      totalProperty: 'total',
      id: 'name'
    },
    [
      {name: 'name'},
      {name: 'execution_time'},
      {name: 'code'},
      {name: "script_execution_time"}
    ]
  );

  triggerStore = new Ext.data.GroupingStore({
    reader: reader,
    groupField:'execution_time',
    groupDir: 'DESC',
    proxy: new Ext.data.HttpProxy({url: 'debug_triggers?r='+Math.random()})
  });

  var debugTriggers = new xg.GridPanel({
      id: 'debugTriggers',
      store: triggerStore,
      columns: [
        {id:'name',header: _('ID_NAME'), width: 60, sortable: true, dataIndex: 'name'},
        {header: _('ID_EXECUTION'), width: 30, sortable: true, dataIndex: 'execution_time'},
        {header: "Code", width: 30, sortable: false, dataIndex: 'code', hidden: true},
        {header: _("ID_EXECUTION_TIME") + " (" + _("ID_MILLISECONDS") + ")", dataIndex: "script_execution_time", width: 60, sortable: true, hidden: true}
      ],

      view: new Ext.grid.GroupingView({
          forceFit:true,
          groupTextTpl: '{text} ({[values.rs.length]} {[ values.rs[0].data.execution_time=="error" || values.rs[0].data.execution_time=="Fatal error"? "<font color=red>"+values.rs[0].data.execution_time+"</font>":  values.rs.length > 1 ? "Triggers" : "Trigger"]})'
      }),

      width: 700,
      height: 450,
      title: TRANSLATIONS.ID_TRIGGERS,
      sm: new Ext.grid.RowSelectionModel({singleSelect: true}),
      viewConfig: {
        forceFit: true
      },
      listeners: {
        rowdblclick: function(grid, n,e) {
          triggerWindow();
        }
      }
  });

  debugTriggers.getSelectionModel().on('rowselect', function(sm, rowIdx, r) {
    Ext.getCmp('deatachAction').setDisabled(false);
    var detailPanel = Ext.getCmp('debug-details-panel');
    debugTriggersDetailTpl.overwrite(detailPanel.body, r.data);
    detailPanel.setTitle(r.data.name);
  });

  function triggerWindow() {
    var r = debugTriggers.getSelectionModel().getSelected();
    if(r) {
      var w = new Ext.Window({
          title: r.data.name,
          width: 500,
          height: 400,
          modal: true,
          autoScroll: true,
          maximizable: true,
          items: [],
          listeners:{
            show: function() {
              this.loadMask = new Ext.LoadMask(this.body, { msg:_('ID_LOADING') });
            }
          }
      });
      w.show();
      debugTriggersDetailTpl.overwrite(w.body, r.data);
    }
  }


  debugPanel = new Ext.Panel({
    id:'debugPanel',
    title: _('ID_DEBUG_PANEL_TITLE'),
    region: regionDebug,
    layout: 'border',
    width: 300,
    height: 500,
    minSize: 175,
    maxSize: 400,
    split: true,
    collapsible: true,
    collapseMode: 'mini',
    margins: '0 0 0 5',
    items: [
      new Ext.TabPanel({
        id: 'debugPanelTabs',
        border: true, // already wrapped so don't add another border
        activeTab: 0, // second tab initially active
        tabPosition: 'top',
        region:'center',
        split: true,
        items: [
          debugVariables,
          debugTriggers
        ],
        listeners: {
          beforetabchange: function(){
            Ext.getCmp('deatachAction').setDisabled(true);
            Ext.getCmp('debug-details-panel').html = '';
          },
            tabchange: function (tabpanel, tab) {
              clearItemSelected(tab.id);
            }
        }
      }),
      {
        region: 'south',
        layout: 'fit',
        title: '&nbsp;',
        id: 'debug-details-panel',
        autoScroll: true,
        collapsible: false,
        split: true,
        margins: '0 2 2 2',
        cmargins: '2 2 2 2',
        height: 50,
        html: detailsText,
        tbar:[
          '->',
          {
            id: 'deatachAction',
            disabled: true,
            text: _('ID_OPEN_IN_A_NEW_WINDOW'),
            iconCls: 'button_menu_ext ss_sprite ss_application_form',
            handler: function(){
              if( Ext.getCmp('debugPanelTabs').getActiveTab().id === 'debugVariables' ){
                var i,
                    store1a = new Ext.data.ArrayStore({fields: result.headers});
                store1a.loadData(result.rows);
                for(i = 0; i < result.columns.length; i += 1){
                  result.columns[i].editor = new Ext.form.TextField({allowBlank: true, readOnly:true})
                }

                var myGridPanel = new Ext.grid.EditorGridPanel({
                  region:'center',
                  store: store1a,
                  autoHeight: true,
                  autoWidth: true,
                  border : false,
                  columns: result.columns,
                  stripeRows : true,
                  layout: 'fit',
                  viewConfig:{forceFit:true, scrollOffset:0},
                  clicksToEdit: 1
                });

                var w = new Ext.Window({
                  title: '',
                  width: 600,
                  height: 250,
                  layout:'fit',
                  autoScroll:true,
                  modal: true,
                  maximizable: true,
                  items: [myGridPanel]
                });
                w.show();
              } else {
                triggerWindow();
              }
            }
          }
        ]
    }]
  });

  function restartPanelDetail () {
      var detailPanel = Ext.getCmp('debug-details-panel'),
          domDetailPanel;
      if (detailPanel && detailPanel.body) {
          domDetailPanel = detailPanel.body.dom;
          detailPanel.setTitle("");
          domDetailPanel.innerHTML = "";
      }
  }

  function clearItemSelected (id) {
      var debugVar = Ext.getCmp("debugVariables"),
          debugTri = Ext.getCmp("debugTriggers");
      switch (id) {
          case "debugTriggers":
              if (debugVar && debugVar.getSelectionModel().getSelected()) {
                  debugVar.getSelectionModel().clearSelections();
                  restartPanelDetail();
              }
              break;
          case "debugVariables":
              if (debugTri && debugTri.getSelectionModel().getSelected()) {
                  debugTri.getSelectionModel().clearSelections();
                  restartPanelDetail();
              }
              break;
      }
  }

  var viewport = new Ext.Viewport({
    layout: 'border',
    items: [ mainMenu, centerPanel, debugPanel]
  });

  /** after panel creation routines */
  var menuPanelC = Ext.getCmp('debugPanel');

  /**hide*/
  menuPanelC.hide();
  menuPanelC.ownerCt.doLayout();

  // Get the counters the first time
  updateCasesTree();
  highlightCasesTree();

  // FORMATS.casesListRefreshTime is in seconds
  setInterval("timer()", parseInt(FORMATS.casesListRefreshTime) * 1000);

  // If the feature for highlight the home folders is enabled, add timer for highlight the tree options
  if (typeof highlightUrlProxy !== "undefined") {
      setInterval("highlightCasesTree()", (parseInt(highlightRefreshTime) * 60) * 1000);
  }
});

function updateCasesView(viewList) {
    var refreshList = viewList || false;
  try{
    if (document.getElementById('casesSubFrame').contentWindow.storeCases) {
        if (refreshList) {
              document.getElementById('casesSubFrame').contentWindow.storeCases.reload();
        } else {
            switch (document.getElementById('casesSubFrame').contentWindow.storeCases.baseParams.action) {
                case "todo":
                case "unassigned":
                case "paused":
                case "to_revise":
                case "to_reassign":
                    document.getElementById('casesSubFrame').contentWindow.storeCases.reload();
                    break;
                default:
                    break;
            }
        }
    }
  } catch(e){}
}

function updateCasesTree() {
  document.getElementById('refreshNotifiers').src = '/images/ext/default/grid/loading.gif';

  Ext.Ajax.request({
    url: urlProxy + Math.random(),
    success: function (response) {
      result = Ext.util.JSON.decode(response.responseText);

      for (i = 0; i < result.length; i++) {
        if (document.getElementById('NOTIFIER_' + result[i].item)) {
          oldValue = document.getElementById('NOTIFIER_' + result[i].item).innerHTML;
          oldValue = oldValue.replace('<b>', '');
          oldValue = oldValue.replace('</b>', '');

          newValue = result[i].count;

          if (oldValue != newValue && oldValue != 0) {
            document.getElementById('NOTIFIER_' + result[i].item).innerHTML = '<b>' + result[i].count + '</b>';
          } else {
            document.getElementById('NOTIFIER_' + result[i].item).innerHTML = result[i].count;
          }
        }
        else continue;
      }
      document.getElementById('refreshNotifiers').src = '/images/refresh.gif';
    },
    failure: function () {
    },
    params: {'updateCasesTree': true}
  });
}

/**
 * Function to highlight the tree options
 */
function highlightCasesTree() {
    if (typeof highlightUrlProxy !== "undefined") {
        document.getElementById('refreshNotifiers').src = '/images/ext/default/grid/loading.gif';

        Ext.Ajax.request({
            url: highlightUrlProxy + Math.random(),
            success: function (response) {
                var result = Ext.util.JSON.decode(response.responseText);
                var treePanelObject = Ext.getCmp('tree-panel');
                for (var i = 0; i < result.length; i++) {
                    var nodeObject = treePanelObject.getNodeById(result[i].item);
                    // Set the style for the option
                    if (result[i].highlight) {
                        nodeObject.setCls('row_updated');
                    } else {
                        nodeObject.setCls('');
                    }
                }
                document.getElementById('refreshNotifiers').src = '/images/refresh.gif';
            },
            failure: function () {
                // Nothing to do for now...
            }
        });
    }
}

function timer() {
    if (flagRefresh) {
      updateCasesTree();
      updateCasesView();
    }
}

Ext.data.DynamicJsonReader = function(config){
  Ext.data.DynamicJsonReader.superclass.constructor.call(this, config, []);
};

Ext.extend(Ext.data.DynamicJsonReader, Ext.data.JsonReader, {
  getRecordType : function(data) {
    var i = 0, arr = [];

    for (var name in data[0]) {
      arr[i++] = name;
    } // is there a built-in to do this?
    this.recordType = Ext.data.Record.create(arr);
    return this.recordType;
  },
  readRecords : function(o){ // this is just the same as base class, with call to getRecordType injected

    this.jsonData = o;
    var s = this.meta;
    var sid = s.id;
    var totalRecords = 0;
    if(s.totalProperty){
      var v = parseInt(eval("o." + s.totalProperty), 10);
      if(!isNaN(v)){
        totalRecords = v;
      }
    }

    var root = s.root ? eval("o." + s.root) : o;
    var recordType = this.getRecordType(root);
    var fields = recordType.prototype.fields;
    var records = [];

    for(var i = 0; i < root.length; i++){
      var n = root[i];
        var values = {};
        var id = (n[sid] !== undefined && n[sid] !== "" ? n[sid] : null);
        for(var j = 0, jlen = fields.length; j < jlen; j++){
          var f = fields.items[j];
          var map = f.mapping || f.name;
          var v = n[map] !== undefined ? n[map] : f.defaultValue;
          v = f.convert(v);
          values[f.name] = v;
        }
        var record = new recordType(values, id);
        record.json = n;
        records[records.length] = record;
    }

    return {
      records : records,
      totalRecords : totalRecords || records.length
    };
  }
});

Ext.app.menuLoader = Ext.extend(Ext.ux.tree.XmlTreeLoader, {
  processAttributes : function(attr){
    //console.log(attr);
    if(attr.blockNestedTree){
      //console.log(attr);
      attr.text = attr.blockTitle;
      attr.iconCls = 'ICON_' + attr.id;
      attr.loaded = false;
      attr.expanded = false;
      attr.xtype = 'treepanel';
      attr.rootVisible = true;
      attr.singleClickExpand=true;
      attr.animate = true;
      attr.nodeType = 'async';
      attr.clearOnReLoad= false;

      attr.loader = new Ext.tree.TreeLoader({
        dataUrl : attr.blockNestedTree,
        baseParams : {
          action : 'expandNode',
          folderID: attr.folderId
        }
      });
      attr.style= {
        // width: '50%',
        height: '50px',
        // marginBottom: '10px',
        overflow:'auto'
      };
    }
    else if(attr.blockHeaderNoChild){
        //console.info(attr);
        attr.text = attr.blockTitle;
        attr.iconCls = 'ICON_' + attr.id;
        attr.loaded = true;
        attr.expanded = false;
        //attr.disabled=true;
        attr.expandable=true;
        attr.qtip=attr.blockTitle;


      }else if(attr.blockTitle){
      attr.text = attr.blockTitle;
      attr.iconCls = 'ICON_' + attr.id;
      attr.loaded = true;
      //if((attr.url)&&(attr.url!="")){
      //  attr.expanded = false;
      //}else{
        attr.expanded = true;
      //}
    }else if(attr.title){
      attr.text = Ext.util.Format.htmlDecode(attr.title);

      if( attr.cases_count )
        attr.text += ' (<label id="NOTIFIER_'+attr.id+'">' + attr.cases_count + '</label>)';

      attr.iconCls = 'ICON_' + attr.id;
      attr.loaded = true;
      attr.expanded = attr.expanded ? true : false;

    } else if(attr.PRO_UID){
      attr.loaded = true;
      attr.leaf = true;
    }
  }
});

var notify = function(title, msg){
  PMExt.notify(title, msg);
};
