<?php
/**
 * processes_Delete.php
 *
 * ProcessMaker Open Source Edition
 * Copyright (C) 2004 - 2008 Colosa Inc.23
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * For more information, contact Colosa Inc, 2566 Le Jeune Rd.,
 * Coral Gables, FL, 33134, USA, or email info@colosa.com.
 */
global $RBAC;
$access = $RBAC->userCanAccess( 'PM_FACTORY' );
if ($access != 1) {
    switch ($access) {
        case - 1:
            G::SendTemporalMessage( 'ID_USER_HAVENT_RIGHTS_PAGE', 'error', 'labels' );
            G::header( 'location: ../login/login' );
            die();
            break;
        case - 2:
        default:
            G::SendTemporalMessage( 'ID_USER_HAVENT_RIGHTS_SYSTEM', 'error', 'labels' );
            G::header( 'location: ../login/login' );
            die();
            break;
    }
}

$uids = explode(',', $_POST['PRO_UIDS']);
try {

    foreach ($uids as $uid) {
        //Add Audit Log
        $oProcess = new Process();
        $process=$oProcess->load($uid);
        $nameProcess=$process['PRO_TITLE'];
        G::auditLog("DeleteProcess", $nameProcess. ' ('.$uid.')' .' Deleted');

        //$oProcessMap->deleteProcess($uid);
        ProcessMaker\Project\Workflow::removeIfExists($uid);
        ProcessMaker\Project\Bpmn::removeIfExists($uid);
    }

    $resp = new StdClass();
    $resp->status = 0;
    $resp->msg = 'All process was deleted successfully';

    echo G::json_encode($resp);

} catch (Exception $e) {
    $resp = new stdClass();
    $resp->status = 1;
    $resp->msg = $e->getMessage();
    echo G::json_encode($resp);
}


