<?php
/**
 * ProcessMaker Open Source Edition
 * Copyright (C) 2004 - 2008 Colosa Inc.23
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * For more information, contact Colosa Inc, 2566 Le Jeune Rd.,
 * Coral Gables, FL, 33134, USA, or email info@colosa.com.
 */

/*
  * @Author Erik Amaru Ortiz <erik@colosa.com>
  * @Date Aug 26th, 2009
  */


$filter = new InputFilter();
$_POST = $filter->xssFilterHard($_POST);
$request = $_POST['request'];

switch ($request) {
    case 'save':
        if (isset( $_POST['items'] )) {
            $items = $_POST['items'];
            $tmpfilename = $_SESSION['Current_Dynafom']['Parameters']['FILE'];
            $tmpfilename = $filter->xssFilterHard($tmpfilename);


            $o = new DynaformHandler( PATH_DYNAFORM . "{$tmpfilename}.xml" );

            $list_elements = explode( ',', $items );

            $e = Array ();
            foreach ($list_elements as $element) {
                $e[] = $o->getNode( $element );
            }

            $o->cloneEmpty();

            foreach ($e as $e1) {
                $o->setNode( $e1 );
            }

        }
        break;
    case 'saveHidden':
        $tmpfilename = $_SESSION['Current_Dynafom']['Parameters']['FILE'];
        $tmpfilename = $filter->xssFilterHard($tmpfilename);

        $o = new DynaformHandler( PATH_DYNAFORM . "{$tmpfilename}.xml" );
        $hidden_items = Array ();

        $has_hidden_items = false;
        if (isset( $_POST['hidden'] )) {
            if ($_POST['hidden'] != '') {
                $has_hidden_items = true;

                $hidden_items = explode( ',', $_POST['hidden'] );
                $hidden_items_tmp = $hidden_items;
                $hidden_items = Array ();
                foreach ($hidden_items_tmp as $hItem) {
                    $tmp = explode( "@", $hItem );
                    $hidden_items[] = $tmp[1];
                }
                $hidden_items_tmp = implode( ',', $hidden_items );
            }
        }

        if ($has_hidden_items) {
            $hStr = '';
            foreach ($hidden_items as $hItem) {
                $hStr .= "hideRowById('$hItem'); ";
            }
            //echo 'something todo';
            //print_r($hidden_items);
            $msg = " @! Autogenerated by Processmaker weboot;  Do not modify this content, this is autogenerated alway when dynaform is updated ";

            if ($o->nodeExists( '___pm_boot_strap___' )) {
                $o->remove( '___pm_boot_strap___' );
            }
            $metaEncrypt = G::encrypt( $hidden_items_tmp, 'dynafieldsHandler' );
            $o->add( '___pm_boot_strap___', Array ('type' => 'javascript',"meta" => $metaEncrypt
            ), "/*$msg*/ $hStr" );
            echo $metaEncrypt;
        } else {
            //we must to remove the boot strap node;
            $o->remove( '___pm_boot_strap___' );
        }
        break;
    default:
        echo 'no request param.';
}

