<?php

require_once 'propel/map/MapBuilder.php';
include_once 'creole/CreoleTypes.php';


/**
 * This class adds structure of 'DYNAFORM' table to 'workflow' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    workflow.classes.model.map
 */
class DynaformMapBuilder
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'classes.model.map.DynaformMapBuilder';

    /**
     * The database map.
     */
    private $dbMap;

    /**
     * Tells us if this DatabaseMapBuilder is built so that we
     * don't have to re-build it every time.
     *
     * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
     */
    public function isBuilt()
    {
        return ($this->dbMap !== null);
    }

    /**
     * Gets the databasemap this map builder built.
     *
     * @return     the databasemap
     */
    public function getDatabaseMap()
    {
        return $this->dbMap;
    }

    /**
     * The doBuild() method builds the DatabaseMap
     *
     * @return     void
     * @throws     PropelException
     */
    public function doBuild()
    {
        $this->dbMap = Propel::getDatabaseMap('workflow');

        $tMap = $this->dbMap->addTable('DYNAFORM');
        $tMap->setPhpName('Dynaform');

        $tMap->setUseIdGenerator(true);

        $tMap->addPrimaryKey('DYN_UID', 'DynUid', 'string', CreoleTypes::VARCHAR, true, 32);

        $tMap->addColumn('DYN_ID', 'DynId', 'int', CreoleTypes::INTEGER, true, null);

        $tMap->addColumn('DYN_TITLE', 'DynTitle', 'string', CreoleTypes::LONGVARCHAR, true, null);

        $tMap->addColumn('DYN_DESCRIPTION', 'DynDescription', 'string', CreoleTypes::LONGVARCHAR, false, null);

        $tMap->addColumn('PRO_UID', 'ProUid', 'string', CreoleTypes::VARCHAR, true, 32);

        $tMap->addColumn('DYN_TYPE', 'DynType', 'string', CreoleTypes::VARCHAR, true, 20);

        $tMap->addColumn('DYN_FILENAME', 'DynFilename', 'string', CreoleTypes::VARCHAR, true, 100);

        $tMap->addColumn('DYN_CONTENT', 'DynContent', 'string', CreoleTypes::LONGVARCHAR, false, null);

        $tMap->addColumn('DYN_LABEL', 'DynLabel', 'string', CreoleTypes::LONGVARCHAR, false, null);

        $tMap->addColumn('DYN_VERSION', 'DynVersion', 'int', CreoleTypes::INTEGER, true, null);

        $tMap->addColumn('DYN_UPDATE_DATE', 'DynUpdateDate', 'int', CreoleTypes::TIMESTAMP, false, null);

        $tMap->addValidator('DYN_TYPE', 'validValues', 'propel.validator.ValidValuesValidator', 'xmlform|grid', 'Please select a valid dynaform type.');

    } // doBuild()

} // DynaformMapBuilder
