module.exports = [
  {
    type: 'confirm',
    name: 'addExamples',
    message: 'Add example code',
    description: 'This will generate a component, graphql files and an example schema (if server is added).',
    default: false,
  },
  {
    type: 'confirm',
    name: 'addServer',
    message: 'Add a GraphQL API Server?',
    description: 'Generate GraphQL server files in a `apollo-server` folder.',
    group: 'GraphQL Server',
    default: false,
  },
  {
    type: 'confirm',
    name: 'addMocking',
    message: 'Enable automatic mocking?',
    description: 'Missing resolvers will be automatically mocked.',
    group: 'GraphQL Server',
    default: false,
    when: answers => answers.addServer,
  },
  {
    type: 'confirm',
    name: 'addApolloEngine',
    message: 'Configure Apollo Engine?',
    link: 'http://engine.apollographql.com/',
    group: 'GraphQL Server',
    default: false,
  },
  {
    type: 'input',
    name: 'apolloEngineService',
    message: 'Apollo Service ID (create one at https://engine.apollographql.com):',
    group: 'GraphQL Server',
    validate: input => !!input,
    when: answers => answers.addApolloEngine,
  },
  {
    type: 'input',
    name: 'apolloEngineKey',
    message: 'API Key:',
    description: `It should look like this: 'service:name-xxxx:xxxxxxxxxxxxxxxxxxxxxx'`,
    group: 'GraphQL Server',
    validate: input => !!input,
    when: answers => answers.addApolloEngine,
  },
  {
    type: 'input',
    name: 'apolloEngineTag',
    message: 'Default Schema Tag:',
    description: 'You can have data over multiples tags, which is useful when having several env like staging and production.',
    group: 'GraphQL Server',
    when: answers => answers.addApolloEngine,
  },
  {
    type: 'confirm',
    name: 'publishSchema',
    message: 'Publish schema on Apollo Engine?',
    group: 'GraphQL Server',
    default: false,
    when: answers => answers.addApolloEngine,
  },
]
