function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { mergeData } from 'vue-functional-data-merge';
import Vue from '../../utils/vue';
import { getComponentConfig } from '../../utils/config';
import { htmlOrText } from '../../utils/html';
import { hasNormalizedSlot, normalizeSlot } from '../../utils/normalize-slot';
import { BInputGroupAppend } from './input-group-append';
import { BInputGroupPrepend } from './input-group-prepend';
import { BInputGroupText } from './input-group-text'; // --- Constants ---

var NAME = 'BInputGroup'; // --- Props ---

export var props = {
  id: {
    type: String
  },
  size: {
    type: String,
    default: function _default() {
      return getComponentConfig(NAME, 'size');
    }
  },
  prepend: {
    type: String
  },
  prependHtml: {
    type: String
  },
  append: {
    type: String
  },
  appendHtml: {
    type: String
  },
  tag: {
    type: String,
    default: 'div'
  }
}; // --- Main component ---
// @vue/component

export var BInputGroup = /*#__PURE__*/Vue.extend({
  name: NAME,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        slots = _ref.slots,
        scopedSlots = _ref.scopedSlots;
    var prepend = props.prepend,
        prependHtml = props.prependHtml,
        append = props.append,
        appendHtml = props.appendHtml,
        size = props.size;
    var $scopedSlots = scopedSlots || {};
    var $slots = slots();
    var slotScope = {};
    var $prepend = h();
    var hasPrependSlot = hasNormalizedSlot('prepend', $scopedSlots, $slots);

    if (hasPrependSlot || prepend || prependHtml) {
      $prepend = h(BInputGroupPrepend, [hasPrependSlot ? normalizeSlot('prepend', slotScope, $scopedSlots, $slots) : h(BInputGroupText, {
        domProps: htmlOrText(prependHtml, prepend)
      })]);
    }

    var $append = h();
    var hasAppendSlot = hasNormalizedSlot('append', $scopedSlots, $slots);

    if (hasAppendSlot || append || appendHtml) {
      $append = h(BInputGroupAppend, [hasAppendSlot ? normalizeSlot('append', slotScope, $scopedSlots, $slots) : h(BInputGroupText, {
        domProps: htmlOrText(appendHtml, append)
      })]);
    }

    return h(props.tag, mergeData(data, {
      staticClass: 'input-group',
      class: _defineProperty({}, "input-group-".concat(size), size),
      attrs: {
        id: props.id || null,
        role: 'group'
      }
    }), [$prepend, normalizeSlot('default', slotScope, $scopedSlots, $slots), $append]);
  }
});