"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateComposedSchema = exports.validateServicesBeforeComposition = exports.validateServicesBeforeNormalization = void 0;
const graphql_1 = require("graphql");
const preNormalizationRules = __importStar(require("./preNormalization"));
const preCompositionRules = __importStar(require("./preComposition"));
const postCompositionRules = __importStar(require("./postComposition"));
const preNormalizationValidators = Object.values(preNormalizationRules);
function validateServicesBeforeNormalization(services) {
    const errors = [];
    for (const serviceDefinition of services) {
        for (const validator of preNormalizationValidators) {
            errors.push(...validator(serviceDefinition));
        }
    }
    return errors;
}
exports.validateServicesBeforeNormalization = validateServicesBeforeNormalization;
const preCompositionValidators = Object.values(preCompositionRules);
exports.validateServicesBeforeComposition = (services) => {
    const warningsOrErrors = [];
    for (const serviceDefinition of services) {
        for (const validator of preCompositionValidators) {
            warningsOrErrors.push(...validator(serviceDefinition));
        }
    }
    return warningsOrErrors;
};
const postCompositionValidators = Object.values(postCompositionRules);
exports.validateComposedSchema = ({ schema, serviceList, }) => {
    const warningsOrErrors = [];
    warningsOrErrors.push(...graphql_1.validateSchema(schema));
    for (const validator of postCompositionValidators) {
        warningsOrErrors.push(...validator({ schema, serviceList }));
    }
    return warningsOrErrors;
};
//# sourceMappingURL=index.js.map